﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class ReasonsService: IReasonsService
    {

        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IReasonsService" />
        public ReasonsService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> ActivateOrDeactivateTest(ReasonsModel model)
        {
            var query = $@"UPDATE ""Reasons""
	                           SET ""ModifiedBy""={model.CreatedBy}, ""ModifiedDate""=now(), ""Active""= {model.Active}
	                           WHERE ""ReasonsId""= {model.ReasonsId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }

        /// <inheritdoc/>
        public async Task<int> DeleteAsync(ReasonsModel model)
        {
            var query = $@"DELETE FROM ""Reasons"" WHERE ""ReasonsId"" = {model.ReasonsId}";
            var result = await this.unitOfWork.Current.ExecuteAsync(query);
            return result;
        }

        /// <inheritdoc/>
        public async Task<IEnumerable<ReasonsModel>> FetchAllAsync(ReasonsModel model)
        {
           
            var query = $@"select count(RS.""ReasonsId"") over() as ""TotalItems"", RS.""ReasonsId"", RS.""Reason"", RS.""Active"", RS.""CreatedBy"", RS.""CreatedDate"",
		                        RS.""ModifiedBy"", RS.""ModifiedDate"",
		                        C.""FullName"" as ""CreatedByName"", M.""FullName"" as ""ModifiedByName""
                             FROM ""Reasons"" RS
                             join ""Account"" C on C.""AccountId"" = RS.""CreatedBy""
                             left join ""Account"" M on M.""AccountId"" = RS.""ModifiedBy""
                             order by RS.""CreatedDate"" desc";


            return await this.unitOfWork.Current.QueryAsync<ReasonsModel>(query);

        }

     

        /// <inheritdoc/>
        public async Task<int> InsertAsync(ReasonsModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""Reasons"" where  lower(""Reason"") = '{model.Reason.ToLower()}'");
            if (checkIf > 0)
            {
                return -1;
            }
            var reason = new Reasons
            {
                Reason = model.Reason,
                CreatedBy = model.CreatedBy,
                Active = true,
                CreatedDate = DateTime.Now,
            };
            return await this.unitOfWork.Reasons.InsertAsync(reason);
        }

        /// <inheritdoc/>
        public async Task<int> UpdateAsync(ReasonsModel model)
        {

                var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""Reasons"" where  lower (""Reason"") = '{model.Reason.ToLower()}' and ""ReasonsId"" <> {model.ReasonsId}");
                if (checkIf > 0)
                {
                    return -1;
                }
                var record = await this.unitOfWork.Reasons.FindAsync(m => m.ReasonsId == model.ReasonsId);
                if (record == null)
                {
                    return -2;
                }
                record.ModifiedBy = model.CreatedBy;
                record.ModifiedDate = DateTime.Now;
                record.Reason = model.Reason;
                return await this.unitOfWork.Reasons.UpdateAsync(record);
            

            
        }
    }
}
