﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The patient family model.
    /// </summary>
    public class PatientFamilyModel
    {
        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }
        
        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public string EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// 
        public string FullName { get; set; }
        
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string ModifiedByName { get; set; }
        
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the relation.
        /// </summary>
        public string Relation { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
       // public int Age { get; set; }
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? RelativeGender { get; set; }
        
        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }
        
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime ModifiedDate { get; set; }
       
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Occupation { get; set; }

        /// <summary>
        /// Gets or sets the occupation details.
        /// </summary>
        /// <value>
        /// The occupation details.
        /// </value>
        public string OccupationDetails { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Education { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public DateTime? DOB { get; set; }
        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string ContactNo { get; set; }

        /// <summary>
        /// Gets or sets the Blood group
        /// </summary>
        public string RelativeBloodGroup { get; set; }
    }
}
