﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The basic bed patient details model.
    /// </summary>
    public class BedPatientDetailsModel
    {
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the admission name.
        /// </summary>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        public string AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public short Age { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public char Gender { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public int DischargeId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string ExpectedDischargeDate { get; set; }
    }
}