﻿namespace Hims.Shared.UserModels.ProgressReport.Timeline
{
    using System;
    using static Hims.Shared.UserModels.ProgressReport.Timeline.Enums;

    /// <summary>
    /// The view model
    /// </summary>
    public class MedicationAllViewModel
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int ProgressReportMedicationId { get; set; }

        /// <summary>
        /// Gets or sets the progress report identifier.
        /// </summary>
        /// <value>
        /// The progress report identifier.
        /// </value>
        public int ProgressReportId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        /// <value>
        /// The unit.
        /// </value>
        public float Unit { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        /// <value>
        /// The duration.
        /// </value>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the medication duration type identifier.
        /// </summary>
        /// <value>
        /// The medication duration type identifier.
        /// </value>
        public int MedicationDurationTypeId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ViewModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the instructions.
        /// </summary>
        /// <value>
        /// The instructions.
        /// </value>
        public string Instructions { get; set; }

        /// <summary>
        /// Gets or sets the stop reason.
        /// </summary>
        /// <value>
        /// The stop reason.
        /// </value>
        public string StopReason { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime GeneralDate { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the product generic.
        /// </summary>
        /// <value>
        /// The name of the product generic.
        /// </value>
        public string ProductGenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the product company.
        /// </summary>
        /// <value>
        /// The name of the product company.
        /// </value>
        public string ProductCompanyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the product type.
        /// </summary>
        /// <value>
        /// The name of the product type.
        /// </value>
        public string ProductTypeName { get; set; }
        /// <summary>
        /// Gets or sets the medication instruction type identifier.
        /// </summary>
        /// <value>
        /// The medication instruction type identifier.
        /// </value>
        public int MedicationInstructionTypeId { get; set; }

        /// <summary>
        /// Gets or sets the medication instruction deep type identifier.
        /// </summary>
        /// <value>
        /// The medication instruction deep type identifier.
        /// </value>
        public int MedicationInstructionDeepTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the medication instruction.
        /// </summary>
        /// <value>
        /// The name of the medication instruction.
        /// </value>
        public string MedicationInstructionName { get; set; }

        /// <summary>
        /// Gets or sets the progress report medication frequency identifier.
        /// </summary>
        /// <value>
        /// The progress report medication frequency identifier.
        /// </value>
        public int ProgressReportMedicationFrequencyId { get; set; }

        /// <summary>
        /// Gets or sets the medication date.
        /// </summary>
        /// <value>
        /// The medication date.
        /// </value>
        public DateTime? MedicationDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public bool? Status { get; set; }

        /// <summary>
        /// Gets or sets the when.
        /// </summary>
        /// <value>
        /// The when.
        /// </value>
        public WhenType? When { get; set; }

        /// <summary>
        /// Gets or sets the active status.
        /// </summary>
        /// <value>
        /// The active status.
        /// </value>
        public ActiveStatus? ActiveStatus { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        /// <value>
        /// The salutation.
        /// </value>
        public string Salutation { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }
    }
}
