﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.Vendors
{
    /// <summary>
    /// The vendor product for approval model.
    /// </summary>
    public class VendorProductForApprovalModel
    {
        /// <summary>
        /// Gets or sets the name of the supplier.
        /// </summary>
        /// <value>
        /// The name of the supplier.
        /// </value>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the product.
        /// </summary>
        /// <value>
        /// The product.
        /// </value>
        public List<PharmacyProductRequestModel> Product { get; set; }
    }


    public class VendorProductApprovalInsertModel
    {
        /// <summary>
        /// Gets or sets the vendors.
        /// </summary>
        /// <value>
        /// The vendors.
        /// </value>
        public List<VendorProductForApprovalModel> Vendors { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy{ get; set; }

        /// <summary>
        /// Gets or sets the deliver date.
        /// </summary>
        /// <value>
        /// The deliver date.
        /// </value>
        public DateTime? DeliverDate { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId{ get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId{ get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId{ get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount{ get; set; }

        /// <summary>
        /// Gets or sets the total tax.
        /// </summary>
        /// <value>
        /// The total tax.
        /// </value>
        public double TotalTax{ get; set; }

        /// <summary>
        /// Gets or sets the total net amount.
        /// </summary>
        /// <value>
        /// The total net amount.
        /// </value>
        public double TotalNetAmount{ get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<VendorProductForApprovalDisplayModel> Products { get; set; }
    }


    /// <summary>
    /// The vendor product for approval display model.
    /// </summary>
    public class VendorProductForApprovalDisplayModel
    {
        /// <summary>
        /// Gets or sets the pharmacy product approval identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product approval identifier.
        /// </value>
        public long PharmacyProductApprovalId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy stock identifier.
        /// </value>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        /// <value>
        /// The tax.
        /// </value>
        public int Tax { get; set; }

        /// <summary>
        /// Gets or sets the tender status identifier.
        /// </summary>
        /// <value>
        /// The tender status identifier.
        /// </value>
        public int TenderStatusId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product request identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product request identifier.
        /// </value>
        public int PharmacyProductRequestId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the raised by.
        /// </summary>
        /// <value>
        /// The name of the raised by.
        /// </value>
        public string RaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the request approved by.
        /// </summary>
        /// <value>
        /// The request approved by.
        /// </value>
        public string RequestApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the raised date.
        /// </summary>
        /// <value>
        /// The raised date.
        /// </value>
        public DateTime RaisedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public string Location { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the name of the supplier.
        /// </summary>
        /// <value>
        /// The name of the supplier.
        /// </value>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the deliver days.
        /// </summary>
        /// <value>
        /// The deliver days.
        /// </value>
        public int? DeliverDays { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        /// <value>
        /// The quantity.
        /// </value>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int Free { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        /// <value>
        /// The tax amount.
        /// </value>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [inventory item].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }

        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }
    }
}
