﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The retail ware house link.
    /// </summary>
    public class RetailWareHouseLink
    {
        /// <summary>
        /// Gets or sets the retail ware house link identifier.
        /// </summary>
        /// <value>
        /// The retail ware house link identifier.
        /// </value>
        [Key, Identity]
        public int RetailWareHouseLinkId { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy identifier.
        /// </summary>
        /// <value>
        /// The retail pharmacy identifier.
        /// </value>
        public int RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int PharmacyWareHouseId { get; set; }
    }
}
