﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IChargeTypesService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ChargeTypesModel>> FetchAsync(ChargeTypesFilterModel model);
        

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ChargeTypesModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// 
        
        Task<int> UpdateAsync(ChargeTypesModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="chargeTypesId">
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int? chargeTypesId);


        /// <summary>
        /// The get charge availability async.
        /// </summary>
        /// <param name="chargeTypesId">
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FindNameByChargeId(int? chargeTypesId);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="chargeTypesId">
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(ChargeTypesModel model);
    }
}
