﻿#nullable enable
namespace VirtualSteth.Shared.UserModels
{
    using System;

    /// <summary>
    /// The provider location user model.
    /// </summary>
    public class ProviderLocationUserModel
    {
        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the practice location id.
        /// </summary>
        public int PracticeLocationId { get; set; }

        /// <summary>
        /// Gets or sets the practice location name.
        /// </summary>
        public string PracticeLocationName { get; set; }

        /// <summary>
        /// Gets or sets the practice id.
        /// </summary>
        public int PracticeId { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the practice TIN.
        /// </summary>
        public string PracticeTIN { get; set; }

        /// <summary>
        /// Gets or sets the consultation duration.
        /// </summary>
        public short? ConsultationDuration { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public decimal? ConsultationCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine duration.
        /// </summary>
        public short? TelemedicineDuration { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public decimal? TelemedicineCharges { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDays { get; set; }

        /// <summary>
        /// Gets or sets the available from.
        /// </summary>
        public TimeSpan AvailableFrom { get; set; }

        /// <summary>
        /// Gets or sets the available to.
        /// </summary>
        public TimeSpan AvailableTo { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string FromTime { get; set; }

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string ToTime { get; set; }

        /// <summary>
        /// Gets or sets the Days
        /// </summary>
        public string Days { get; set; }
    }
}
