﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities
{
    public class PackageModule
    {
        [Key, Identity]
        public int PackageModuleId { get; set; }

        public int LocationId { get; set; }

        public int? ProviderId { get; set; }

        public string PackageName { get; set; }

        public int PackageTypeId { get; set; }

        public int ModuleTypeId { get; set; }

        public int ChargeModuleTemplateId { get; set; }

        public string ModulesMasterIds { get; set; }

        public short Quantity { get; set; }

        public short? FreeQuantity { get; set; }

        public string Notes { get; set; }

        public string Exclusions { get; set; }

        public short? ExpiresIn { get; set; }

        public string DiscountType { get; set; }

        public decimal? DiscountPercentage { get; set; }

        public decimal? DiscountAmount { get; set; }

        public bool Active { get; set; }

        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        public int? ModifiedBy { get; set; }

        public DateTime? ModifiedDate { get; set; }
    }
}
