﻿
namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using System.Text;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class ReferralForm
    {
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        [Key, Identity]
        public int ReferralFormId { get; set; }
        /// <summary>
        /// Gets or sets provider id.
        /// </summary>
        public string? ReferralDoctor { get; set; }
        /// <summary>
        /// Gets or sets reason.
        /// </summary>
        public string? Reason { get; set; }
        /// <summary>
        /// Gets or sets required date.
        /// </summary>
        public DateTime? RequiredDate { get; set; }
        /// <summary>
        /// Gets or sets time.
        /// </summary>
        public string? Time { get; set; }

        /// <summary>
        /// Gets or sets created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or set consultant doctor.
        /// </summary>
        public string? ConsultantDoctor { get; set; }
        /// <summary>
        /// Gets or sets the opinion.
        /// </summary>
        public string? Opinion { get; set; }
        /// <summary>
        /// Gets or sets active.
        /// </summary>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int AppointmentId { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? ReferralDoctorId { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int AdmissionId { get; set; }
    }
}
