﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class Room
    {
        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        [Key, Identity]
        public int RoomId { get; set; }
        /// <summary>
        /// Gets or sets Beds count in a room.
        /// </summary>
        public int BedsCount { get; set; }
        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int WardId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string RoomName { get; set; }
        
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public int RoomRent { get; set; }
        

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        
        /// <summary>
        /// Gets or sets the charge category id.
        /// </summary>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the module master identifier.
        /// </summary>
        /// <value>
        /// The module master identifier.
        /// </value>
        [IgnoreUpdate]
        public int ModulesMasterId { get; set; }
    }
}
