﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    /// <summary>
    /// The settings
    /// </summary>
    public class Settings
    {
        /// <summary>
        /// Gets or sets the dynamic template.
        /// </summary>
        /// <value>
        /// The appointment type.
        /// </value>
        [Key, Identity]
        public int SettingsId { get; set; }

        /// <summary>
        /// Gets or sets the type of the settings.
        /// </summary>
        /// <value>
        /// The type of the setting(optional).
        /// </value>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the name of the settings.
        /// </summary>
        /// <value>
        /// The name of the setting.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the value of the settings.
        /// </summary>
        /// <value>
        /// The value of the setting.
        /// </value>
        public string? Value { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the image url name.
        /// </summary>
        public string? ImageUrl { get; set; }

        /// <summary>
        /// Gets or sets the Description.
        /// </summary>
        public string? Description { get; set; }

       
    }
}
