﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The ticket timeline.
    /// </summary>
    public class TicketTimeline
    {
        /// <summary>
        /// Gets or sets the ticket timeline id.
        /// </summary>
        [Key, Identity]
        public long TicketTimelineId { get; set; }

        /// <summary>
        /// Gets or sets the ticket id.
        /// </summary>
        public long TicketId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the assigned to.
        /// </summary>
        public int AssignedTo { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        public DateTime? EndDate { get; set; }

        /// <summary>
        /// Gets or sets the assigned date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime AssignedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public string Priority { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public int? AssignedToUser { get; set; }
    }
}