﻿namespace Hims.Domain.Entities.Vendors
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The incoming quoatation header.
    /// </summary>
    [Table("IncomingQuotationHeader", Schema = "vendors")]
    public class IncomingQuotationHeader
    {
        /// <summary>
        /// Gets or sets the incoming quotation header identifier.
        /// </summary>
        /// <value>
        /// The incoming quotation header identifier.
        /// </value>
        [Key,Identity]
        public long IncomingQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the product for quotation header identifier.
        /// </summary>
        /// <value>
        /// The product for quotation header identifier.
        /// </value>
        public long ProductForQuotationHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is finalized.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is finalized; otherwise, <c>false</c>.
        /// </value>
        public bool IsFinalized { get; set; }

        /// <summary>
        /// Gets or sets the finalized by.
        /// </summary>
        /// <value>
        /// The finalized by.
        /// </value>
        public int? FinalizedBy { get; set; }

        /// <summary>
        /// Gets or sets the finalized date.
        /// </summary>
        /// <value>
        /// The finalized date.
        /// </value>
        public DateTime? FinalizedDate { get; set; }

        /// <summary>
        /// Gets or sets the delivery date.
        /// </summary>
        /// <value>
        /// The delivery date.
        /// </value>
        public DateTime? DeliveryDate { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total tax.
        /// </summary>
        /// <value>
        /// The total tax.
        /// </value>
        public double TotalTax { get; set; }

        /// <summary>
        /// Gets or sets the total net amount.
        /// </summary>
        /// <value>
        /// The total net amount.
        /// </value>
        public double TotalNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the total discount.
        /// </summary>
        /// <value>
        /// The total discount.
        /// </value>
        public double TotalDiscount { get; set; }
    }
}
