﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.PediatricGraphs;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary>
    /// The id proof Service interface.
    /// </summary>
    public interface IDenverChartService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(DenverChartModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DenverChartModel>> FetchAllAsync(DenverChartModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<DenverChartModel>> FetchByAppointmentIdAsync(DenverChartModel model);

        //Task<int> UpdateAsync(DenverChartModel model);


    }
}
