﻿using Hims.Shared.EntityModels;
using Hims.Shared.UserModels.diet_package;
using Hims.Shared.UserModels.PackageModule;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    public interface IDietConditionHeaderService
    {

        Task<IEnumerable<DietConditionsModel>> FetchItemsAsync(DietConditionsModel model);

        Task<IEnumerable<DietConditionsModel>> FetchMeasureAsync(DietConditionsModel model);

        Task<int> InsertItemsAsync(DietSlotsModel model, List<DietConditionsDetailModel> dietConditionsModel);
        Task<int> UpdateItemsAsync(DietSlotsModel model, List<DietConditionsDetailModel> dietConditionsModel);

        Task<int> UpdateAsync(DietConditionsModel model);

        Task<int> ModifyStatusAsync(DietConditionsModel model);
        Task<int> ModifyPackageStatusAsync(DietConditionsModel model);
        Task<IEnumerable<DietConditionsDetailModel>> FetchDietPackageAsync(DietConditionsDetailModel model);
        Task<DietPackageViewModel> ViewAsync(int conditionId);

    }
}
