﻿namespace Hims.Shared.Dapper.Attributes.Joins
{
    /// <inheritdoc />
    /// <summary>
    ///     Generate LEFT JOIN
    /// </summary>
    public sealed class LeftJoinAttribute : JoinAttributeBase
    {
        /// <inheritdoc />
        /// <summary>
        /// Initializes a new instance of the <see cref="T:Hims.Shared.Dapper.Attributes.Joins.LeftJoinAttribute" /> class.
        ///     Constructor
        /// </summary>
        public LeftJoinAttribute()
        {
        }

        /// <inheritdoc />
        /// <summary>
        /// Initializes a new instance of the <see cref="T:Hims.Shared.Dapper.Attributes.Joins.LeftJoinAttribute" /> class.
        ///     Constructor
        /// </summary>
        /// <param name="tableName">
        /// Name of external table
        /// </param>
        /// <param name="key">
        /// ForeignKey of this table
        /// </param>
        /// <param name="externalKey">
        /// Key of external table
        /// </param>
        public LeftJoinAttribute(string tableName, string key, string externalKey)
            : base(tableName, key, externalKey, string.Empty, string.Empty)
        {
        }

        /// <inheritdoc />
        /// <summary>
        ///     Constructor
        /// </summary>
        /// <param name="tableName">Name of external table</param>
        /// <param name="key">ForeignKey of this table</param>
        /// <param name="externalKey">Key of external table</param>
        /// <param name="tableSchema">Name of external table schema</param>
        public LeftJoinAttribute(string tableName, string key, string externalKey, string tableSchema)
            : base(tableName, key, externalKey, tableSchema, string.Empty)
        {
        }

        /// <inheritdoc />
        /// <summary>
        ///     Constructor
        /// </summary>
        /// <param name="tableName">Name of external table</param>
        /// <param name="key">ForeignKey of this table</param>
        /// <param name="externalKey">Key of external table</param>
        /// <param name="tableSchema">Name of external table schema</param>
        /// <param name="tableAbbreviation">External table alias</param>
        public LeftJoinAttribute(string tableName, string key, string externalKey, string tableSchema, string tableAbbreviation)
            : base(tableName, key, externalKey, tableSchema, tableAbbreviation)
        {
        }
    }
}