﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The account.
    /// </summary>
    public class AccountModel
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? RoleName { get; set; }

        /// <summary>
        /// Gets or sets the reference id.
        /// </summary>
        public int ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the salt key.
        /// </summary>
        public string SaltKey { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int CountryId { get; set; }

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string? CountryCode { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether agreed locked.
        /// </summary>
        public bool? IsAgreed { get; set; }

        /// <summary>
        /// Gets or sets the agreed date.
        /// </summary>
        public DateTime? AgreedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is locked.
        /// </summary>
        public bool IsLocked { get; set; }

        /// <summary>
        /// Gets or sets a value otp verified.
        /// </summary>
        public bool? OTPVerified { get; set; }

        /// <summary>
        /// Gets or sets a value manual verified.
        /// </summary>
        public bool? ManualVerified { get; set; }

        /// <summary>
        /// Gets or sets a value manual verified.
        /// </summary>
        public bool? PasswordExist { get; set; }

        /// <summary>
        /// Gets or sets the failed login attempts.
        /// </summary>
        public short FailedLoginAttempts { get; set; }

        /// <summary>
        /// Gets or sets the last failed login date.
        /// </summary>
        public DateTime? LastFailedLoginDate { get; set; }

        /// <summary>
        /// Gets or sets the last login date.
        /// </summary>
        public DateTime? LastLoginDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public char? Status { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the Patient Guid.
        /// </summary>
        public Guid PatientGuid { get; set; }

        /// <summary>
        /// Gets or sets the Description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the location identifiers.
        /// </summary>
        /// <value>
        /// The location identifiers.
        /// </value>
        public string? LocationIdentifiers { get; set; }

        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        public string? UserName { get; set; }
    }
}