﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.EntityModels
{
    public class AmbulanceModel
    {

        /// <summary>
        /// get or set AmbulanceId
        /// </summary>
        [Key, Identity]
        public int AmbulanceId { get; set; }

        /// <summary>
        /// get or set AmbulanceNo
        /// </summary>
        public string AmbulanceNo { get; set; }

        /// <summary>
        /// get or set AssignedNo
        /// </summary>
        public string AssignedNo { get; set; }

        /// <summary>
        /// get or set Active
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// get or set CreatedDate
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// get or set
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// get or set ModifiedBy
        /// </summary>

        public int? ModifiedBy { get; set; }

        /// <summary>
        /// get or set ModifiedDate
        /// </summary>

        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the ambulance created name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the ambulance  modified name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>        
        public int LocationId { get; set; }

    }
}
