﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The behavioral health full transcript model.
    /// </summary>
    public class BehavioralHealthFullTranscriptModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int BehavioralHealthId { get; set; }

        /// <summary>
        /// Gets or sets the problem history.
        /// </summary>
        public string? ProblemHistory { get; set; }

        /// <summary>
        /// Gets or sets the medical history.
        /// </summary>
        public string? MedicalHistory { get; set; }

        /// <summary>
        /// Gets or sets the current support.
        /// </summary>
        public string? CurrentSupport { get; set; }

        /// <summary>
        /// Gets or sets the current living.
        /// </summary>
        public string? CurrentLiving { get; set; }

        /// <summary>
        /// Gets or sets the educational history.
        /// </summary>
        public string? EducationalHistory { get; set; }

        /// <summary>
        /// Gets or sets the client strengths.
        /// </summary>
        public string? ClientStrengths { get; set; }

        /// <summary>
        /// Gets or sets the out come measures.
        /// </summary>
        public string? OutComeMeasures { get; set; }

        /// <summary>
        /// Gets or sets the substance history.
        /// </summary>
        public string? SubstanceHistory { get; set; }

        /// <summary>
        /// Gets or sets the work history.
        /// </summary>
        public string? WorkHistory { get; set; }

        /// <summary>
        /// Gets or sets the abuse history.
        /// </summary>
        public string? AbuseHistory { get; set; }

        /// <summary>
        /// Gets or sets the religion spirituality.
        /// </summary>
        public string? ReligionSpirituality { get; set; }

        /// <summary>
        /// Gets or sets the mental status.
        /// </summary>
        public string? MentalStatus { get; set; }

        /// <summary>
        /// Gets or sets the family relationships.
        /// </summary>
        public string? FamilyRelationships { get; set; }

        /// <summary>
        /// Gets or sets the relapse predictors.
        /// </summary>
        public string? RelapsePredictors { get; set; }

        /// <summary>
        /// Gets or sets the patient questionnaire.
        /// </summary>
        public string? PatientQuestionnaire { get; set; }

        /// <summary>
        /// Gets or sets the generalised anxiety disorder.
        /// </summary>
        public string? GeneralisedAnxietyDisorder { get; set; }

        /// <summary>
        /// Gets or sets the burns depression.
        /// </summary>
        public string? BurnsDepression { get; set; }

        /// <summary>
        /// Gets or sets the aims.
        /// </summary>
        public string? Aims { get; set; }

        /// <summary>
        /// Gets or sets the geno gram.
        /// </summary>
        public string? GenoGram { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        public string? Notes { get; set; }

        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the referral provider.
        /// </summary>
        public string? ReferralProvider { get; set; }

        /// <summary>
        /// Gets or sets the follow up.
        /// </summary>
        public string? FollowUp { get; set; }

        /// <summary>
        /// Gets or sets the medications.
        /// </summary>
        public string? Medications { get; set; }

        /// <summary>
        /// Gets or sets the treatment plan.
        /// </summary>
        public string? TreatmentPlan { get; set; }

        /// <summary>
        /// Gets or sets the symptoms.
        /// </summary>
        public string? Symptoms { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the medication comment.
        /// </summary>
        public string? MedicationComment { get; set; }
    }
}
