﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class CubicleModel
    {
        /// <summary>
        /// Gets or sets the widget id.
        /// </summary>
        public int CubicleId { get; set; }
        
        /// <summary>
        /// Gets or sets the widget name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the name of the provider.
        /// </summary>
        /// <value>
        /// The name of the provider.
        /// </value>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the name of the active status.
        /// </summary>
        /// <value>
        /// The name of the active status.
        /// </value>
        public string ActiveStatusName { get; set; }

        /// <summary>
        /// Gets or sets the active status id.
        /// </summary>
        public int ActiveStatusId { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? ProviderId { get; set; }
         
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }
        
        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the Log From.
        /// </summary>
        public short? LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the Total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the Location Id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the Location Name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets Assigned/UnAssigned Cubicles.
        /// </summary>
        public int? Assign { get; set; }


        public int? AccountId { get; set; }


        public string AssignedName { get; set; }

    }
}
