﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The auditLog.
    /// </summary>
    public class ExceptionLogModel
    {
        /// <summary>
        /// Gets or sets the exception log id.
        /// </summary>
        public int ExceptionLogId { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the log time.
        /// </summary>
        public TimeSpan LogTime { get; set; }

        /// <summary>
        /// Gets or sets the log date and time.
        /// </summary>
        public DateTime LogTimestamp { get; set; }

        /// <summary>
        /// Gets or sets the log form.
        /// </summary>
        public string LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the log route.
        /// </summary>
        public string LogRoute { get; set; }

        /// <summary>
        /// Gets or sets the error message.
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }
        /// <summary>
        ///  Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? LogPath { get; set; }
        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? LogPathMethod { get; set; }
        
    }
}