﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The pharmacy indent header model.
    /// </summary>
    public class PharmacyIndentHeaderModel
    {
        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the indent date.
        /// </summary>
        public DateTime? IndentDate { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        public DateTime? RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the indent on.
        /// </summary>
        public DateTime? IndentOn { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the approved by.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the approved by name.
        /// </summary>
        public string ApprovedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the request date.
        /// </summary>
        public DateTime? RequestDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the num requested items.
        /// </summary>
        public long NumRequestedItems { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public string Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the Patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the Patient id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the requested by.
        /// </summary>
        public int? RequestedBy { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int? IssueQuantity { get; set; }

        /// <summary>
        /// Gets or sets the issue product name.
        /// </summary>
        public string IssueProductName { get; set; }


        /// <summary>
        /// Gets or sets the issue category name.
        /// </summary>
        public string IssueCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double? IssueNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the ot indent header id.
        /// </summary>
        public int? OTIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the approved by role.
        /// </summary>
        public string ApprovedByRole { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the rejected products exists or not.
        /// </summary>
        public bool? IsRejectedProductsExists { get; set; }

        /// <summary>
        /// Gets or sets the type of the indent status.
        /// </summary>
        /// <value>
        /// The type of the indent status.
        /// </value>
        public IndentStatusType IndentStatusTypeId { get; set; }

        /// <summary>
        /// Gets or sets the is receipt generated.
        /// </summary>
        /// <value>
        /// The is receipt generated.
        /// </value>
        public bool? IsReceiptGenerated { get; set; }

        /// <summary>
        /// Gets or sets the receipt identifier.
        /// </summary>
        /// <value>
        /// The receipt identifier.
        /// </value>
        public int? ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the approved by name person's -Role .
        /// </summary>
        public string ApprovedByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the created by name person's -Role .
        /// </summary>
        public string CreatedByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent detail id.
        /// </summary>
        public int PharmacyIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy issue detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy issue detail identifier.
        /// </value>
        public int PharmacyIssueDetailId { get; set; }

        /// <summary>
        /// Gets or sets the name of the retail.
        /// </summary>
        /// <value>
        /// The name of the retail.
        /// </value>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        /// <value>
        /// The return quantity.
        /// </value>
        public int? ReturnQuantity { get; set; }
    }

    /// <summary>
    /// The indent status type.
    /// </summary>
    public enum IndentStatusType
    {
        /// <summary>
        /// The complete
        /// </summary>
        Complete = 1,

        /// <summary>
        /// The not complete
        /// </summary>
        NotComplete = 2
    }
}
