﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The ScanLog.
    /// </summary>
    public class ScanLogModel
    {
        /// <summary>
        /// Gets or sets the scan log id.
        /// </summary>
        public int ScanLogId { get; set; }

        /// <summary>
        /// Gets or sets the Scan Log type id.
        /// </summary>
        public int ScanLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the log type name.
        /// </summary>
        public string? LogTypeName { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the log from.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? RoleName { get; set; }

        /// <summary>
        /// Gets or sets the log description.
        /// </summary>
        public string LogDescription { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the Scan name.
        /// </summary>
        public string? ScanName { get; set; }

        /// <summary>
        /// Gets or sets the Location Id  
        /// </summary>
        public int? LocationId { get; set; }
    }
}