﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The daily sales model.
    /// </summary>
    public class DailySalesMedicationModel
    {
        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the supplier name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the sale quantity.
        /// </summary>
        public double SaleQuantity { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double Discount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the payment Type.
        /// </summary>
        public string PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the payment Type.
        /// </summary>
        public DateTime SaleDate { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double PurchaseValue { get; set; }
        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public int PurchaseUnitQty { get; set; }

        /// <summary>
        /// Gets or sets the payment /transaction number.
        /// </summary>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the net amount .
        /// </summary>
        public double OverallNetAmount { get; set; }

    }
}