﻿#nullable enable
namespace Hims.Shared.UserModels.DoctorScheduleVisits
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class FilterModel
    {

        /// <summary>
        /// Gets or sets the Provider Availability Visit Id
        /// </summary>
        public int DoctorAvailabilityVisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public int? Duration { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the sepecialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the location iud.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }
    }
}
