﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The appointment filter model.
    /// </summary>
    public class AdmissionFilterModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        public string? DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string? AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the mobile no.
        /// </summary>
        /// <value>
        /// The mobile no.
        /// </value>
        public string? MobileNo { get; set; }

        /// <summary>
        /// Gets or sets the is discharged.
        /// </summary>
        public bool? IsDischarged { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the UMR number.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? BedAssociatedData { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? NRIData { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? SurrogacyData { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? EmergencyInfo { get; set; }

        public int? PatientPriorityId { get; set; }
    }
}
