﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The transaction filter model.
    /// </summary>
    public class TransactionReportsFilterModel
    {
        

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string FromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string ToDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }
       
        /// <summary>
        /// Gets or sets the receipt Id.
        /// </summary>
        public string? ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the paymentType.
        /// </summary>
        public int? PaymentType { get; set; } 

        /// <summary>
        /// Gets or sets the location
        /// </summary>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the Pay Type id.
        /// </summary>
        public int? PayTypeId { get; set; }
        /// <summary>
        /// Gets or sets the ReceiptAreaType  id.
        /// </summary>
        public int? ReceiptAreaTypeId { get; set; }
    }
}
