﻿using System.Collections.Generic;
using Hims.Domain.Entities.Enums;

namespace Hims.Shared.UserModels.FinalBill
{
    using System;
    using FinalBillServiceOrder = ServiceOrder;
    /// <summary>
    /// The receipt model
    /// </summary>
    public class BasicViewModel
    {
        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmountPaid { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount type identifier.
        /// </summary>
        /// <value>
        /// The discount type identifier.
        /// </value>
        public int? DiscountTypeId { get; set; }

        /// <summary>
        /// Gets or sets the discount details.
        /// </summary>
        /// <value>
        /// The discount details.
        /// </value>
        public double? DiscountDetails { get; set; }

        /// <summary>
        /// Gets or sets the final amount.
        /// </summary>
        /// <value>
        /// The final amount.
        /// </value>
        public double FinalAmount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is final bill generated.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is final bill generated; otherwise, <c>false</c>.
        /// </value>
        public bool IsFinalBillGenerated { get; set; }

        /// <summary>
        /// Gets or sets the pending amount.
        /// </summary>
        /// <value>
        /// The pending amount.
        /// </value>
        public double PendingAmount { get; set; }

        /// <summary>
        /// Gets or sets the is discharged.
        /// </summary>
        /// <value>
        /// The is discharged.
        /// </value>
        public bool IsDischarged { get; set; }
        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the is service taken.
        /// </summary>
        /// <value>
        /// The is discharged.
        /// </value>
        public bool IsServiceTaken { get; set; }

        /// <summary>
        /// Gets or sets the is service taken.
        /// </summary>
        /// <value>
        /// The is discharged.
        /// </value>
        public bool IsFinalGatePass { get; set; }

        /// <summary>
        /// Gets or sets the is service taken.
        /// </summary>
        /// <value>
        /// The is discharged.
        /// </value>
        public bool IsProvisionalGatePass { get; set; }

    }
}
