﻿namespace Hims.Shared.UserModels.Inventory
{
    using System;

    /// <summary>
    /// The inventory department consumption model.
    /// </summary>
    public class InventoryDepartmentConsumptionModel
    {
        /// <summary>
        /// Gets or sets the inventory department consumption identifier.
        /// </summary>
        /// <value>
        /// The inventory department consumption identifier.
        /// </value>
        public int InventoryDepartmentConsumptionId { get; set; }

        /// <summary>
        /// Gets or sets the inventory departmental stock identifier.
        /// </summary>
        /// <value>
        /// The inventory departmental stock identifier.
        /// </value>
        public int? InventoryDepartmentalStockId { get; set; }

        /// <summary>
        /// Gets or sets the inventory department identifier.
        /// </summary>
        /// <value>
        /// The inventory department identifier.
        /// </value>
        public int? InventoryDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the quantity consumed.
        /// </summary>
        /// <value>
        /// The quantity consumed.
        /// </value>
        public int QuantityConsumed { get; set; }

        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        /// <value>
        /// The available quantity.
        /// </value>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the consumed by.
        /// </summary>
        /// <value>
        /// The consumed by.
        /// </value>
        public int? ConsumedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the quantity before consumption.
        /// </summary>
        /// <value>
        /// The quantity before consumption.
        /// </value>
        public int? QuantityBeforeConsumption { get; set; }

        /// <summary>
        /// Gets or sets the reason for consumption.
        /// </summary>
        /// <value>
        /// The reason for consumption.
        /// </value>
        public string ReasonForConsumption { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the stock credited date.
        /// </summary>
        /// <value>
        /// The stock credited date.
        /// </value>
        public DateTime StockCreditedDate { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        /// <value>
        /// The tax percentage.
        /// </value>
        public int TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        /// <value>
        /// The quantity in.
        /// </value>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        /// <value>
        /// The quantity out.
        /// </value>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the consumed by.
        /// </summary>
        /// <value>
        /// The name of the consumed by.
        /// </value>
        public string ConsumedByName { get; set; }

        /// <summary>
        /// Gets or sets the consumed by role.
        /// </summary>
        /// <value>
        /// The consumed by role.
        /// </value>
        public string ConsumedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public string FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the inventory product ids.
        /// </summary>
        /// <value>
        /// The inventory product ids.
        /// </value>
        public string InventoryProductIds { get; set; }
    }
}
