﻿namespace Hims.Shared.UserModels.Medications
{
    /// <summary>
    /// The medicines model.
    /// </summary>
    public class MedicinesModel
    {
        /// <summary>
        /// Gets or sets the instructions.
        /// </summary>
        public string Instructions { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is morning.
        /// </summary>
        public bool IsMorning { get; set; }

        /// <summary>
        /// Gets or sets the morning dosage.
        /// </summary>
        public string MorningDosage { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is night.
        /// </summary>
        public bool IsNight { get; set; }

        /// <summary>
        /// Gets or sets the night dosage.
        /// </summary>
        public string NightDosage { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is afternoon.
        /// </summary>
        public bool IsAfternoon { get; set; }

        /// <summary>
        /// Gets or sets the afternoon dosage.
        /// </summary>
        public string AfternoonDosage { get; set; }

        /// <summary>
        /// Gets or sets the dosage.
        /// </summary>
        public string Dosage { get; set; }

        /// <summary>
        /// Gets or sets the duration type.
        /// </summary>
        public string DurationType { get; set; }

        /// <summary>
        /// Gets or sets the medicine type.
        /// </summary>
        public string MedicineType { get; set; }

        /// <summary>
        /// Gets or sets the medicine search type.
        /// </summary>
        public string MedicineSearchType { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public string Duration { get; set; }

        /// <summary>
        /// Gets or sets the medicine name.
        /// </summary>
        public string MedicineName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is selected.
        /// </summary>
        public bool IsSelected { get; set; }
    }
}