﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.Pharmacy
{
    /// <summary>
    /// The excel retail store sheet model.
    /// </summary>
    public class ExcelRetailStoreSheetModel
    {
        /// <summary>
        /// Gets or sets the stores.
        /// </summary>
        /// <value>
        /// The stores.
        /// </value>
        public List<RetailStoreFromExcelModel> Stores { get; set; }

        /// <summary>
        /// Gets or sets the departments.
        /// </summary>
        /// <value>
        /// The departments.
        /// </value>
        public List<DepartmentFromExcelModel> Departments { get; set; }

        /// <summary>
        /// Gets or sets the retail stock.
        /// </summary>
        /// <value>
        /// The retail stock.
        /// </value>
        public List<ExcelRetailStockSheetModel> RetailStock { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the excel upload history id. 
        /// </summary>
        public int ExcelUploadHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the sheet name.
        /// </summary>
        public string SheetName { get; set; }

        /// <summary>
        /// Gets or sets the value indicating is create log.
        /// </summary>
        public bool IsCreateLog { get; set; }
    }

    /// <summary>
    /// The retail store from excel model.
    /// </summary>
    public class RetailStoreFromExcelModel
    {
        /// <summary>
        /// Gets or sets the matched warehouses.
        /// </summary>
        /// <value>
        /// The matched warehouses.
        /// </value>
        public List<string> MatchedWarehouses { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public string Location { get; set; }

        /// <summary>
        /// Gets or sets the retail store.
        /// </summary>
        /// <value>
        /// The retail store.
        /// </value>
        public string RetailStore { get; set; }
    }

    /// <summary>
    /// The department from excel model.
    /// </summary>
    public class DepartmentFromExcelModel
    {
        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        public string Location { get; set; }
    }
}
