﻿namespace Hims.Shared.UserModels
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics.CodeAnalysis;

    /// <summary>
    /// The Retail store Model -Indent n Issue to ip(inpatient)
    /// </summary>
    public class PharmacyRetailDetailModel
    {
        /// <summary>
        /// Gets or sets IndentHeaderId
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the Indent Detail id.
        /// </summary>
        public int PharmacyIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the Retail Pharmacy Id.
        /// </summary>
        public int RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the Retail Name.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the Pharmacy Stock Id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the Pharmacy Product Id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the IssueHeaderId.
        /// </summary>
        public int PharmacyIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the IssueDetailId.
        /// </summary>
        public int PharmacyIssueDetailId { get; set; }

        /// <summary>
        /// Gets or sets the IndentDates.
        /// </summary>
        public DateTime IndentDate { get; set; }

        /// <summary>
        /// Gets or sets the IndentQty .
        /// </summary>
        public int IndentQty { get; set; }

        /// <summary>
        /// Gets or sets the RequiredDate.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets theIssueDate.
        /// </summary>
        public DateTime IssueDate { get; set; }

        /// <summary>
        /// Gets or sets the IssueQty.
        /// </summary>
        public int IssueQty { get; set; }

        /// <summary>
        /// Gets or sets the ExpiryDate.
        /// </summary>
        public DateTime ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the BatchNumber
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the IssueDetailId.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double? Total { get; set; }

        /// <summary>
        /// Gets or sets the IssueDetailId.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the BatchNumber
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the Indent Name.
        /// </summary>
        public string IndentByName { get; set; }

        /// <summary>
        /// Gets or sets the IndentByrole Name.
        /// </summary>
        public string IndentByRoleName { get; set; }


        /// <summary>
        /// Gets or sets the Indent Name.
        /// </summary>
        public string IssueByName { get; set; }

        /// <summary>
        /// Gets or sets the IndentByrole Name.
        /// </summary>
        public string IssueByRoleName { get; set; }

        /// <summary>
        /// Gets or sets theeReceipt id
        /// </summary>
        public int ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the Discount Amount
        /// </summary>
        public double DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the Net  Amount
        /// </summary>
        public double NetAmount { get; set; }

    }

}
