﻿namespace Hims.Shared.UserModels.RequestSupplier
{ 
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The request indent header model.
    /// </summary>
    public class RequestSupplierHeaderModel
    {
        /// <summary>
        /// Gets or sets the request indent header id.
        /// </summary>
        public int RequestSupplierHeaderId { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the request indent status id.
        /// </summary>
        public int RequestIndentStatusId { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the request indent type id.
        /// </summary>
        public int RequestIndentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment no of days.
        /// </summary>
        public int PaymentNoOfDays { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? ToDate { get; set; }        
            
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the request number.
        /// </summary>
        public string RequestNumber { get; set; }

        /// <summary>
        /// Gets or sets the request number.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the request number.
        /// </summary>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the request number.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the request number.
        /// </summary>
        public string ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the request number.
        /// </summary>
        public string IndentType { get; set; }

        /// <summary>
        /// Gets or sets the request number.
        /// </summary>
        public string IndentStatus { get; set; }

        /// <summary>
        /// Gets or sets the quotation count.
        /// </summary>
        /// <value>
        /// The quotation count.
        /// </value>
        public int QuotationCount { get; set; }

        /// <summary>
        /// Gets or sets the name of the approved by.
        /// </summary>
        /// <value>
        /// The name of the approved by.
        /// </value>
        public string ApprovedByName { get; set; }

        /// <summary>
        /// Gets or sets the approved by role.
        /// </summary>
        /// <value>
        /// The approved by role.
        /// </value>
        public string ApprovedByRole { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string DetailApprovedByName { get; set; }

        /// <summary>
        /// gets or sets the detail approved by name.
        /// </summary>
        public string DetailApprovedBy { get; set; }

        /// <summary>
        /// gets or sets the detail approved date.
        /// </summary>
        public DateTime? DetailApprovedDate { get; set; }

        /// <summary>
        /// gets or sets the detail approved by role
        /// </summary>
        public string DetailApprovedByRole { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<RequestSupplierProductModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy request indent header id.
        /// </summary>
        /// <value>
        /// The pharmacy request indent header id.
        /// </value>
        public int PharmacyRequestIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the indent number.
        /// </summary>
        /// <value>
        /// The indent number.
        /// </value>
        public string IndentNumber { get; set; }
        /// <summary>
        /// Gets or sets the indent number.
        /// </summary>
        /// <value>
        /// The Product.
        /// </value>
        public string Product { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the detail status.
        /// </summary>
        public string DetailStatus { get; set; }
    }

    /// <summary>
    /// The request indent product model.
    /// </summary>
    public class RequestSupplierProductModel
    {

        


    }
}
