﻿using System;
namespace Hims.Shared.UserModels.Vendors
{

    /// <summary>
    /// The inventory product request model.
    /// </summary>
    public class InventoryProductRequestModel
    {
        /// <summary>
        /// Gets or sets the inventory product request identifier.
        /// </summary>
        /// <value>
        /// The inventory product request identifier.
        /// </value>
        public int InventoryProductRequestId { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int? PharmacyProductId { get; set; }
        /// <summary>
        /// Gets or sets the name of the request product.
        /// </summary>
        /// <value>
        /// The name of the request product.
        /// </value>
        public string RequestProductName { get; set; }
        /// <summary>
        /// Gets or sets the reason for request.
        /// </summary>
        /// <value>
        /// The reason for request.
        /// </value>
        public string ReasonForRequest { get; set; }
        /// <summary>
        /// Gets or sets the requested quantity.
        /// </summary>
        /// <value>
        /// The requested quantity.
        /// </value>
        public int RequestedQuantity { get; set; }
        /// <summary>
        /// Gets or sets the type of the request.
        /// </summary>
        /// <value>
        /// The type of the request.
        /// </value>
        public string RequestType { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy product request identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product request identifier.
        /// </value>
        public long? PharmacyProductRequestId { get; set; }
        /// <summary>
        /// Gets or sets the rejected by.
        /// </summary>
        /// <value>
        /// The rejected by.
        /// </value>
        public int? RejectedBy { get; set; }
        /// <summary>
        /// Gets or sets the name of the rejected by.
        /// </summary>
        /// <value>
        /// The name of the rejected by.
        /// </value>
        public string RejectedByName { get; set; }
        /// <summary>
        /// Gets or sets the rejected date.
        /// </summary>
        /// <value>
        /// The rejected date.
        /// </value>
        public DateTime? RejectedDate { get; set; }
        /// <summary>
        /// Gets or sets the reject reason.
        /// </summary>
        /// <value>
        /// The reject reason.
        /// </value>
        public string RejectReason { get; set; }

        /// <summary>
        /// Gets or sets the document URL.
        /// </summary>
        /// <value>
        /// The document URL.
        /// </value>
        public string DocumentUrl { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }
        /// <summary>
        /// Gets or sets the name of the company.
        /// </summary>
        /// <value>
        /// The name of the company.
        /// </value>
        public string CompanyName { get; set; }
        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }
        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }
        /// <summary>
        /// Gets or sets the approval given by.
        /// </summary>
        /// <value>
        /// The approval given by.
        /// </value>
        public string ApprovalGivenBy { get; set; }
        /// <summary>
        /// Gets or sets the name of the approval given by.
        /// </summary>
        /// <value>
        /// The name of the approval given by.
        /// </value>
        public string ApprovalGivenByName { get; set; }
        /// <summary>
        /// Gets or sets the approval given date.
        /// </summary>
        /// <value>
        /// The approval given date.
        /// </value>
        public DateTime? ApprovalGivenDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int? TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }
        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is approved.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is approved; otherwise, <c>false</c>.
        /// </value>
        public bool? IsApproved { get; set; }
    }
}
