﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class DietConditionHeader
    {
        /// <summary>
        /// Gets or sets the diet item id.
        /// </summary>
        [Key, Identity]
        public int ConditionId { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string ConditionName { get; set; }


        /// <summary>
        /// Gets or sets the active or inactive.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        public string ShiftIds { get; set; }
    }
}
