﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The inventory purchase return detail.
    /// </summary>
    public class InventoryPurchaseReturnDetail
    {
        /// <summary>
        /// Gets or sets the inventory purchase return detail id.
        /// </summary>
        [Key, Identity]
        public int InventoryPurchaseReturnDetailId { get; set; }

        /// <summary>
        /// Gets or sets the inventory purchase return header id.
        /// </summary>
        public int InventoryPurchaseReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the serial no.
        /// </summary>
        public int SerialNo { get; set; }

        /// <summary>
        /// Gets or sets the inventory product id.
        /// </summary>
        public int InventoryProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the inventory stock id.
        /// </summary>
        public int InventoryStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }
    }
}
