﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using System;

    using Hims.Shared.UserModels;
    using System.Collections.Generic;
    using Hims.Shared.UserModels.Scan.ScanClassification;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Scan.ScanMachine;

    /// <summary>
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IScanClassificationService
    {



        /// <summary>
        /// The add ob encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsertModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(InsertModel model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<FetchModel>> FetchAll(FetchModel model); 

        /// <summary>
        /// Activates the or deactivate classification.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateClassification(InsertModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="roomId">
        /// The specialization id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int scanClassificationId);
    }
}
