﻿using System.Linq;

namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <inheritdoc />
    public class PayTypeServices : IPayTypeService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IPayTypeService" />
        public PayTypeServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<PayTypeModel>> FetchAsync(PayTypeModel model)
        {
            var where = " WHERE 1 = 1 ";
            if (model.PayTypeId > 0)
            {
                where += $@" and  ""PayTypeId"" = {model.PayTypeId} ";
            }
            if (model.PayTypeValue != null)
            {
                where += $@" AND ""PayTypeValue"" = '{model.PayTypeValue}'";
            }
            if (model.IsActive != null) 
            {
                where += $@" AND ""IsActive"" IS {((bool)model.IsActive ? "TRUE" : "FALSE")}";
            }
            if (model.SalucroPayType != null) 
            {
                where += $@" AND ""SalucroPayType"" IS {((bool)model.SalucroPayType ? "TRUE" : "FALSE")}";
            }
            var query = $@"SELECT count(""PayTypeId"") over() as TotalItems, * FROM ""PayType"" {where} Order by ""PayTypeId"" DESC";

            if (model.PageIndex <= 0 || model.PageIndex == null)
            {
                return this.unitOfWork.Current.QueryAsync<PayTypeModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<PayTypeModel>(query);
        }


        /// <inheritdoc />
        public async Task<int> ActivateOrDeactivatePayType(PayTypeModel model)
        { try
            {
                var query = $@"UPDATE ""PayType""
	                           SET ""IsActive""= {model.IsActive}
	                           WHERE ""PayTypeId""= {model.PayTypeId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }
            catch(Exception e)
            {
                throw e;           }
            }

        /// <inheritdoc/>
        public async Task<int> InsertAsync(PayTypeModel model)
        {
            try
            {
                var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(""PayTypeId"") from ""PayType"" where lower(""PayTypeName"") = '{model.PayTypeName.ToLower()}'");

                if (checkIf > 0)
                {
                    return -1;
                }
                var newpaytype = new PayType
                {
                    PayTypeName = model.PayTypeName,
                    IsActive = true,
                    Description = "anything",
                    PayTypeValue = model.PayTypeName.ToLower(),

                    

                    SalucroPayType = (bool)model.SalucroPayType,

                };
                return await this.unitOfWork.PayTypes.InsertAsync(newpaytype);
            }
            catch(Exception e)
            {
                throw e;
            }
        }

        /// <inheritdoc/>
        public async Task<int> UpdateAsync(PayTypeModel model)
        {
            var res = await this.unitOfWork.PayTypes.FindAsync(m => m.PayTypeId == model.PayTypeId);
            res.PayTypeName = model.PayTypeName;
            res.Description = "Modified";
            res.PayTypeValue = model.PayTypeName.ToLower();
            res.SalucroPayType = (bool)model.SalucroPayType;
            return await this.unitOfWork.PayTypes.UpdateAsync(res);
        }
    }
}