﻿using System.Collections.Generic;
using Hims.Domain.Entities.Enums;

namespace Hims.Shared.UserModels.FinalBill
{
    using Hims.Shared.UserModels.Laboratory;
    using System;
    using FinalBillServiceOrder = ServiceOrder;
    using ServicePackage = Hims.Shared.UserModels.ServiceOrder.Package;

    /// <summary>
    /// The receipt model
    /// </summary>
    public class BasicModel
    {
        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the final bill identifier.
        /// </summary>
        /// <value>
        /// The final bill identifier.
        /// </value>
        public int FinalBillId { get; set; }

        /// <summary>
        /// Gets or sets the discount type identifier.
        /// </summary>
        /// <value>
        /// The discount type identifier.
        /// </value>
        public int? DiscountTypeId { get; set; }

        /// <summary>
        /// Gets or sets the discount details.
        /// </summary>
        /// <value>
        /// The discount details.
        /// </value>
        public double? DiscountDetails { get; set; }

        /// <summary>
        /// Gets or sets the Patient Name.
        /// </summary>
        /// <value>
        /// The Patient Name.
        /// </value>
        public string FullName { get; set; }
    }

    /// <summary>
    /// The view model
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the basic.
        /// </summary>
        /// <value>
        /// The basic.
        /// </value>
        public BasicModel Basics { get; set; }

        /// <summary>
        /// Gets or sets the general records.
        /// </summary>
        /// <value>
        /// The general records.
        /// </value>
        public List<FinalBillServiceOrder.ViewModel> GeneralRecords { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy records.
        /// </summary>
        /// <value>
        /// The pharmacy records.
        /// </value>
        public List<FinalBillServiceOrder.ViewModel> PharmacyRecords { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy records.
        /// </summary>
        /// <value>
        /// The pharmacy records.
        /// </value>
        public List<LabServicesModel> LabServicesRecords { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy records.
        /// </summary>
        /// <value>
        /// The pharmacy records.
        /// </value>
        public List<ServicePackage.ViewModel> PackageRecords { get; set; }

    }
}
