﻿namespace Hims.Shared.UserModels.Labs
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The lab receive model.
    /// </summary>
    public class LabReceiveModel
    {
        /// <summary>
        /// Gets or sets the lab transfer header identifier.
        /// </summary>
        /// <value>
        /// The lab transfer header identifier.
        /// </value>
        public int LabTransferHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the transfer number.
        /// </summary>
        /// <value>
        /// The transfer number.
        /// </value>
        public string TransferNumber { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public string FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the transfered by.
        /// </summary>
        /// <value>
        /// The transfered by.
        /// </value>
        public int TransferedBy { get; set; }

        /// <summary>
        /// Gets or sets the transfered date.
        /// </summary>
        /// <value>
        /// The transfered date.
        /// </value>
        public DateTime TransferedDate { get; set; }

        /// <summary>
        /// Gets or sets the transfered location identifier.
        /// </summary>
        /// <value>
        /// The transfered location identifier.
        /// </value>
        public int TransferedLocationId { get; set; }

        /// <summary>
        /// Gets or sets the received by.
        /// </summary>
        /// <value>
        /// The received by.
        /// </value>
        public int ReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the received date.
        /// </summary>
        /// <value>
        /// The received date.
        /// </value>
        public DateTime ReceivedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the transfered by.
        /// </summary>
        /// <value>
        /// The name of the transfered by.
        /// </value>
        public string TransferedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the received by.
        /// </summary>
        /// <value>
        /// The name of the received by.
        /// </value>
        public string ReceivedByName { get; set; }

        /// <summary>
        /// Gets or sets the transfered to location.
        /// </summary>
        /// <value>
        /// The transfered to location.
        /// </value>
        public string TransferedToLocation { get; set; }

        /// <summary>
        /// Gets or sets the labs.
        /// </summary>
        /// <value>
        /// The labs.
        /// </value>
        public List<LabReceiveDetailModel> Labs { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        /// <value>
        /// The page item.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the page.
        /// </summary>
        /// <value>
        /// The name of the page.
        /// </value>
        public string PageName { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the type of the booking.
        /// </summary>
        /// <value>
        /// The type of the booking.
        /// </value>
        public string? BookingType { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string? RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the transferred temperature.
        /// </summary>
        /// <value>
        /// The transferred temperature.
        /// </value>
        public int? TransferredTemperature { get; set; }

        /// <summary>
        /// Gets or sets the transferred temperature comments.
        /// </summary>
        /// <value>
        /// The transferred temperature comments.
        /// </value>
        public string? TransferredTemperatureComments { get; set; }
    }

    /// <summary>
    /// The lab receive detail model.
    /// </summary>
    public class LabReceiveDetailModel
    {
        /// <summary>
        /// Gets or sets the lab transfer detail identifier.
        /// </summary>
        /// <value>
        /// The lab transfer detail identifier.
        /// </value>
        public int LabTransferDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab transfer header identifier.
        /// </summary>
        /// <value>
        /// The lab transfer header identifier.
        /// </value>
        public int LabTransferHeaderId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection detail identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection detail identifier.
        /// </value>
        public int? LabSampleCollectionDetailId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the created location.
        /// </summary>
        /// <value>
        /// The name of the created location.
        /// </value>
        public string CreatedLocationName { get; set; }

        /// <summary>
        /// Gets or sets the booked date.
        /// </summary>
        /// <value>
        /// The booked date.
        /// </value>
        public DateTime BookedDate { get; set; }

        /// <summary>
        /// Gets or sets the collection date.
        /// </summary>
        /// <value>
        /// The collection date.
        /// </value>
        public DateTime CollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the sub collection date.
        /// </summary>
        /// <value>
        /// The sub collection date.
        /// </value>
        public DateTime? SubCollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the sample.
        /// </summary>
        /// <value>
        /// The name of the sample.
        /// </value>
        public string SampleName { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        /// <value>
        /// The mobile.
        /// </value>
        public string Mobile { get; set; }

    }
}
