﻿
namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using System.Text;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class CommonEncounter
    {
        
        /// <summary>
        /// Gets or sets the gyn encounter id.
        /// </summary>
        [Key, Identity]
        public int CommonEncounterId { get; set; }
        /// <summary>
        /// Gets or sets provider id.
        /// </summary>
        public string? FamilyHistory { get; set; }
        /// <summary>
        /// Gets or sets reason.
        /// </summary>
        public string? ProblemList { get; set; }
        
        public bool? Active { get; set; }        

        /// <summary>
        /// Gets or set consultant doctor.
        /// </summary>
        public string? BirthHistory { get; set; }
        
       public string? Surgeries { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int AppointmentId { get; set; }
       
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int? PatientId { get; set; }
        /// <summary>
        /// Gets or sets created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets created date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets appointment id.
        /// </summary>
        public int ModifiedBy { get; set; }
        public string? GPLA { get; set; }
    }
}
