﻿namespace Hims.Domain.Entities.ProviderMedication
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

	/// <summary>
	/// The provider medication master.
	/// </summary>
	public class ProviderMedicationMaster
	{
        /// <summary>
        /// Gets or sets the provider medication master identifier.
        /// </summary>
        /// <value>
        /// The provider medication master identifier.
        /// </value>
        [Key,Identity]
		public int ProviderMedicationMasterId { get; set; }

        /// <summary>
        /// Gets or sets the provider medication group identifier.
        /// </summary>
        /// <value>
        /// The provider medication group identifier.
        /// </value>
        public int ProviderMedicationGroupId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        /// <value>
        /// The duration.
        /// </value>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the dosage.
        /// </summary>
        /// <value>
        /// The dosage.
        /// </value>
        public int Dosage { get; set; }

        /// <summary>
        /// Gets or sets the type of the duration.
        /// </summary>
        /// <value>
        /// The type of the duration.
        /// </value>
        public string DurationType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is morning.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is morning; otherwise, <c>false</c>.
        /// </value>
        public bool IsMorning { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is afternoon.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is afternoon; otherwise, <c>false</c>.
        /// </value>
        public bool IsAfternoon { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is night.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is night; otherwise, <c>false</c>.
        /// </value>
        public bool IsNight { get; set; }

        /// <summary>
        /// Gets or sets the morning dosage.
        /// </summary>
        /// <value>
        /// The morning dosage.
        /// </value>
        public string MorningDosage { get; set; }

        /// <summary>
        /// Gets or sets the afternoon dosage.
        /// </summary>
        /// <value>
        /// The afternoon dosage.
        /// </value>
        public string AfternoonDosage { get; set; }

        /// <summary>
        /// Gets or sets the night dosage.
        /// </summary>
        /// <value>
        /// The night dosage.
        /// </value>
        public string NightDosage { get; set; }

        /// <summary>
        /// Gets or sets the instruction.
        /// </summary>
        /// <value>
        /// The instruction.
        /// </value>
        public string Instruction { get; set; }
    }
}
