﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.Menu;
    using Relationship = Shared.UserModels.Menu.Relationship;
    using Access = Shared.UserModels.Menu.Access;
    using Button = Shared.UserModels.Menu.Button;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IMenuService
    {
        Task<IEnumerable<Button.ViewModel>> FetchMenuButtonsAsync(Relationship.FilterModel model);

        Task<int> AddButtonAsync(Button.InsertModel model);

        /// <summary>
        /// Updates the relationships asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateRelationshipsAsync(Relationship.UpdateModel model);

        /// <summary>
        /// Gets the menu access asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<Access.ViewModel> GetMenuAccessAsync(Relationship.FilterModel model);

        /// <summary>
        /// Frees the fetch asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<string>> FreeFetchAsync();

        /// <summary>
        /// Fetches the relationship asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<Relationship.ViewModel>> FetchRelationshipAsync(Relationship.FilterModel model);


        /// <summary>
        /// Fetches the roles asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Relationship.RoleViewModel>> FetchRolesAsync();

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync();

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(List<InsertModel> model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// finds the name by role id.
        /// </summary>
        /// <param name="roleId"></param>
        /// <returns></returns>

        Task<string> FindNameByRoleId(int roleId);

        /// <summary>
        /// Adds the only asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddOnlyAsync(InsertModel model);

        /// <summary>
        /// Removes the only asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> RemoveOnlyAsync(InsertModel model);
    }
}
