﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.EntityModels
{
    public class AdmissionTransferRequestModel
    {
        /// <summary>
        /// Gets or sets the admission transfer request id.
        /// </summary>
        public int? AdmissionTransferRequestId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the doctor unit master id.
        /// </summary>
        public int? DoctorUnitMasterId { get; set; }
        /// <summary>
        /// Gets or sets the doctor unit master id.
        /// </summary>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? ChargeCategoryName { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? UnitName { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public string? ChargeCategories { get; set; } = null;
        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public int AdmissionChangeRequestTypeId { get; set; }
        /// <summary>
        /// Gets or sets the charge categories.
        /// </summary>
        public string? RequestComments { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? ApprovedByName { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? ChangeRequestType { get; set; }


        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public int? BedId { get; set; }


        /// <summary>
        /// Gets or sets the RejectedBy.
        /// </summary>
        public int? RejectedBy { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? RejectedByName { get; set; }
        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public DateTime? RejectedDate { get; set; }
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }
        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }
        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }
    }
}
