﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    using Hims.Shared.Library.Enums;

    /// <summary> The homeopathy filter model.</summary>
    public class HomeopathyFilterModel
    {
        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int HomeopathyId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string? EncryptedHomeopathyId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }
        
        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public HomeopathyType Type { get; set; }
    }
}