﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The appointment transaction.
    /// </summary>
    public class AppointmentTransaction
    {
        /// <summary>
        /// Gets or sets the appointment transaction id.
        /// </summary>
        [Key, Identity]
        public int AppointmentTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the Transaction id.
        /// </summary>
        [IgnoreUpdate]
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        [IgnoreUpdate]
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime TransactionDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the bank reference.
        /// </summary>
        public string BankReference { get; set; }

        /// <summary>
        /// Gets or sets the bank code.
        /// </summary>
        public string BankCode { get; set; }

        /// <summary>
        /// Gets or sets the payment id.
        /// </summary>
        public long PaymentId { get; set; }

        /// <summary>
        /// Gets or sets the payment mode id.
        /// </summary>
        public int PaymentModeId { get; set; }

        /// <summary>
        /// Gets or sets the refund id.
        /// </summary>
        public int? RefundId { get; set; }

        /// <summary>
        /// Gets or sets the payment status id.
        /// </summary>
        public int? PaymentStatusId { get; set; }

        /// <summary>
        /// Gets or sets the settled amount.
        /// </summary>
        public decimal? SettledAmount { get; set; }

        /// <summary>
        /// Gets or sets the payout id.
        /// </summary>
        public int? PayoutId { get; set; }

        /// <summary>
        /// Gets or sets the settled date.
        /// </summary>
        public DateTime? SettledDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public double? Percentage { get; set; }

        /// <summary>
        /// Gets or sets the status code.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the salucro transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the receipt type id.
        /// </summary>
        public int ReceiptTypeId { get; set; }

        /// <summary>
        /// Gets or sets the receipt area type id.
        /// </summary>
        public int ReceiptAreaTypeId { get; set; }

        /// <summary>
        /// Gets or sets the voucher number.
        /// </summary>
        [IgnoreUpdate]
        public string VoucherNumber { get; set; }

        /// <summary>
        /// Gets or sets the SendedVia.
        /// </summary>

        public string SendedVia { get; set; }

        /// <summary>
        /// Gets or sets the Received in.
        /// </summary>

        public string ReceivedIn { get; set; }

        /// <summary>
        /// Gets or sets the status check in progress.
        /// </summary>
        public bool StatusCheckInProgress { get; set; }

        /// <summary>
        /// Gets or sets the receipt area type id.
        /// </summary>
        public int? PatientId { get; set; }
        
        /// <summary>
        /// Gets or sets the pay status.
        /// </summary>
        public char? PayStatus { get; set; }
    }
}
