﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The health card.
    /// </summary>
    public class IssueHealthCard
    {
        /// <summary>
        /// Gets or sets the issue health card id.
        /// </summary>
        [Key, Identity]
        public int IssueHealthCardId { get; set; }

        /// <summary>
        /// Gets or sets the health card name.
        /// </summary>
        public int HealthCardId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public string CardNumber { get; set; }

        /// <summary>
        /// Gets or sets the allow members.
        /// </summary>
        public int PatientId { get; set; }


        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]

        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the issued date.
        /// </summary>
        public DateTime IssuedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the paytype id.
        /// </summary>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }
        /// <summary>
        /// Gets or sets the valid till.
        /// </summary>
        public DateTime ValidTill { get; set; }
        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

    }
}
