﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab booking header.
    /// </summary>
    public class LabBookingHeader
    {
        /// <summary>
        /// Gets and sets the lab booking header id.
        /// </summary>
        [Key, Identity]
        public int LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets patient type.
        /// </summary>
        public string PatientType { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        //public string PaidVia { get; set; } adding paytypeId instead.

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the booking date.
        /// </summary>
        public DateTime BookingDate { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount percentage.
        /// </summary>
        public double? OverallDiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the value indicating weather its active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        public string? Notes { get; set; }

        /// <summary>
        /// Gets or sets the Lab location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the Pay Type id.
        /// </summary>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment/transaction number.
        /// </summary>
        public string PaymentNumber { get; set; }
    }
}
