﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab parameter header.
    /// </summary>
    public class LabParameterHeader
    {
        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>
        [Key, Identity]
        public int LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the parameter.
        /// </summary>
        /// <value>
        /// The name of the parameter.
        /// </value>
        public string ParameterName { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the reference output.
        /// </summary>
        /// <value>
        /// The reference output.
        /// </value>
        public string ReferenceOutput { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabParameterHeader"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter method identifier.
        /// </summary>
        /// <value>
        /// The lab parameter method identifier.
        /// </value>
        public int? LabParameterMethodId { get; set; }
        /// <summary>
        /// Gets or sets the text.
        /// </summary>
        /// <value>
        /// The text.
        /// </value>
        public string? Text { get; set; }

        /// <summary>
        /// Gets or sets the machine identifier.
        /// </summary>
        /// <value>
        /// The machine identifier.
        /// </value>
        public int MachineId { get; set; }

        /// <summary>
        /// Gets or sets the name of the machine parameter.
        /// </summary>
        /// <value>
        /// The name of the machine parameter.
        /// </value>
        public string MachineParameterName { get; set; }

        /// <summary>
        /// Gets or sets the parameter identifier.
        /// </summary>
        /// <value>
        /// The parameter identifier.
        /// </value>
        public string ParameterId { get; set; }
    }
}
